<?php
echo "hola";
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Constantes configurables
define('TIMEOUT_MINUTES', 20); // Tiempo de inactividad antes de reiniciar el flujo
define('LOG_FILE', 'error_log.txt'); // Archivo para registrar errores

// Conexión a la base de datos
$dsn = 'mysql:host=localhost;dbname=wwgrup_bot_codigos';
$username = 'wwgrup_bot_codigos';
$password = '25855801Aa*';
$options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION];
$db = new PDO($dsn, $username, $password, $options);

// Función para registrar logs de errores
function logError($message) {
    file_put_contents(LOG_FILE, date('[Y-m-d H:i:s]') . " $message\n", FILE_APPEND);
}

// Función para registrar interacciones
function logInteraction($sender, $message, $direction) {
    global $db;
    $stmt = $db->prepare("INSERT INTO conversation_logs (sender, message, direction, timestamp) VALUES (:sender, :message, :direction, NOW())");
    $stmt->execute([
        ':sender' => $sender, 
        ':message' => $message, 
        ':direction' => $direction
    ]);
}

// Función para enviar mensajes
function sendMessage($receiver, $message) {
    try {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://whatsnode.com/api/create-message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => array(
                'appkey' => '54d2d35f-3534-472e-8cad-a0e6d0512473',
                'authkey' => 'FazCCVpULaoaq68D1lopWfcWj4DIdWWuwr8G72V482zlbXC9Xi',
                'to' => $receiver,
                'message' => $message,
                'sandbox' => 'false'
            )
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        logInteraction($receiver, $message, 'outgoing');
        return $response;
    } catch (Exception $e) {
        logError("Error enviando mensaje a $receiver: " . $e->getMessage());
        return false;
    }
}

// Función para procesar el número de teléfono
function processPhoneNumber($phone) {
    return trim($phone);
}

// Función para consultar consult.php
function consultAccess($email, $phone, $platform) {
    $url = "https://bot-codigos.elgamermexicano.com/consult.php?email=" . urlencode($email) . "&telefono=" . urlencode($phone) . "&platform=" . urlencode($platform);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

// Función para manejar el flujo de conversación
function processWebhook($postData) {
    global $db;
    try {
        if (empty($postData['sender']) || empty($postData['payload'])) {
            throw new Exception("Datos incompletos en el webhook");
        }
        
        $sender = $postData['sender'];
        $message = '';
        
        // Extraer mensaje
        if (isset($postData['payload']['extendedTextMessage']['text'])) {
            $message = $postData['payload']['extendedTextMessage']['text'];
        } elseif (isset($postData['payload']['conversation'])) {
            $message = $postData['payload']['conversation'];
        } else {
            $message = "";
        }
        
        $message = trim(strtolower($message));
        logInteraction($sender, $message, 'incoming');

        // Obtener flujo actual
        $stmt = $db->prepare("SELECT * FROM conversation_flow WHERE sender = :sender");
        $stmt->execute([':sender' => $sender]);
        $flow = $stmt->fetch(PDO::FETCH_ASSOC);

        // Iniciar flujo si no existe
        if (!$flow) {
            $welcomeMessage = "👋 Hola soy @BotGamerMX\n\n¡Bienvenido! 😊 Estoy aquí para ayudarte con tus códigos de acceso.\n\nPor favor selecciona una plataforma:\n1.- Netflix\n2.- Disney";
            sendMessage($sender, $welcomeMessage);
            
            $stmt = $db->prepare("INSERT INTO conversation_flow (sender, stage, last_interaction, platform) VALUES (:sender, 'awaiting_platform', NOW(), '')");
            $stmt->execute([':sender' => $sender]);
            return;
        }

        // Verificar tiempo de espera
        $datetime = new DateTime($flow['last_interaction']);
        $now = new DateTime();
        $interval = $now->diff($datetime);
        if ($interval->i >= TIMEOUT_MINUTES) {
            $stmt = $db->prepare("DELETE FROM conversation_flow WHERE sender = :sender");
            $stmt->execute([':sender' => $sender]);
            sendMessage($sender, "⏰ Tiempo de espera agotado. Por favor, envía cualquier mensaje para reiniciar.");
            return;
        }

        // Actualizar última interacción
        $stmt = $db->prepare("UPDATE conversation_flow SET last_interaction = NOW() WHERE sender = :sender");
        $stmt->execute([':sender' => $sender]);

        // Manejar etapas del flujo
        switch ($flow['stage']) {
            case 'awaiting_platform':
                $platforms = [
                    '1' => 'netflix',
                    'netflix' => 'netflix',
                    '2' => 'disney',
                    'disney' => 'disney'
                ];
                
                if (!isset($platforms[$message])) {
                    sendMessage($sender, "❌ Opción no válida. Por favor selecciona:\n1.- Netflix\n2.- Disney");
                    return;
                }
                
                $platform = $platforms[$message];
                $stmt = $db->prepare("UPDATE conversation_flow SET stage = 'awaiting_email', platform = :platform WHERE sender = :sender");
                $stmt->execute([':platform' => $platform, ':sender' => $sender]);
                
                if ($platform === 'netflix') {
                    sendMessage($sender, "📺 Cuando veas el mensaje en Netflix 'Estoy de viaje' o 'Actualizar hogar', haz clic para solicitar el código.\n\nIntroduce el correo asociado a tu cuenta:");
                    sendMessage($sender, "📧 Ingresa tu correo para obtener el código de acceso de Netflix:");
                } else {
                    sendMessage($sender, "🎬 Has seleccionado Disney. Por favor, ingresa tu correo para obtener el código de acceso:");
                }
                break;

            case 'awaiting_email':
                if (!filter_var($message, FILTER_VALIDATE_EMAIL)) {
                    sendMessage($sender, "❌ Correo inválido. Por favor ingresa un correo válido:");
                    return;
                }
                
                sendMessage($sender, "⏳ Procesando tu solicitud...");
                
                $processedPhone = processPhoneNumber($sender);
                $response = consultAccess($message, $processedPhone, $flow['platform']);
                $data = json_decode($response, true);

                if ($flow['platform'] === 'netflix') {
                    if ($data && isset($data['link']) && $data['link'] != "no") {
                        $shortLink = file_get_contents('https://tinyurl.com/api-create.php?url=' . urlencode($data['link']));
                        sendMessage($sender, "✅ Dale click en el siguiente enlace:\n$shortLink\n\n🔔 Si te lleva solo a Netflix, vuelve a enviar el código.");
                    } else {
                        sendMessage($sender, "❌ No se encontró enlace. Intenta de nuevo más tarde.");
                    }
                } elseif ($flow['platform'] === 'disney') {
                    if ($data && isset($data['codigo'])) {
                        sendMessage($sender, "🔑 Tu código para Disney es:\n" . $data['codigo']);
                    } else {
                        sendMessage($sender, "❌ No se encontró código. Intenta de nuevo más tarde.");
                    }
                }
                
                $stmt = $db->prepare("DELETE FROM conversation_flow WHERE sender = :sender");
                $stmt->execute([':sender' => $sender]);
                break;
        }
        
    } catch (Exception $e) {
        logError("Error procesando webhook: " . $e->getMessage());
        sendMessage($sender, "⚠️ Ocurrió un error. Por favor intenta nuevamente.");
    }
}

// Manejar datos POST
$postData = json_decode(file_get_contents('php://input'), true);
if ($postData) {
    processWebhook($postData);
}
?>